#include <iostream>
#include <vector>


using namespace std;

typedef long double ld;
typedef long long ll;

const ll INF = 1e9;

struct segtree_mn {
    ll n;
    vector<ll> t;
    segtree_mn() {}
    segtree_mn(vector<ll>& in) {
        n = in.size();
        t.resize(4 * n);
        build(0, 0, n - 1, in);
    }
    void build(ll v, ll tl, ll tr, vector<ll>& in) {
        if (tl == tr) {
            t[v] = in[tl];
            return;
        }
        ll tm = (tl + tr) / 2;
        build(2 * v + 1, tl, tm, in);
        build(2 * v + 2, tm + 1, tr, in);
        t[v] = min(t[2 * v + 1], t[2 * v + 2]);
    }
    ll get_seg(ll v, ll tl, ll tr, ll l, ll r) {
        if (l <= tl && tr <= r) {
            return t[v];
        }
        if (tr < l || r < tl) {
            return 0;
        }
        ll tm = (tl + tr) / 2;
        return min(get_seg(2 * v + 1, tl, tm, l, r), get_seg(2 * v + 2, tm + 1, tr, l, r));
    }

    ll get(ll l, ll r) {
        return get_seg(0, 0, n - 1, l, r);
    }
};

struct segtree_hard {
    ll n;
    vector<pair<ll, ll>> t;
    segtree_hard() {}
    segtree_hard(vector<ll>& in) {
        n = in.size();
        t.resize(4 * n);
        build(0, 0, n - 1, in);
    }
    void build(ll v, ll tl, ll tr, vector<ll>& in) {
        if (tl == tr) {
            t[v] = { 2 * (-in[tl]) - (tl + 1), tl };
            return;
        }
        ll tm = (tl + tr) / 2;
        build(2 * v + 1, tl, tm, in);
        build(2 * v + 2, tm + 1, tr, in);
        t[v] = max(t[2 * v + 1], t[2 * v + 2]);
    }
    pair<ll, ll> get_seg(ll v, ll tl, ll tr, ll l, ll r) {
        if (l <= tl && tr <= r) {
            return t[v];
        }
        if (tr < l || r < tl) {
            return { -INF, -INF };
        }
        ll tm = (tl + tr) / 2;
        return max(get_seg(2 * v + 1, tl, tm, l, r), get_seg(2 * v + 2, tm + 1, tr, l, r));
    }

    pair<ll, ll> get(ll l, ll r) {
        return get_seg(0, 0, n - 1, l, r);
    }
};

void solve() {
    ll n, q; cin >> n >> q;
    string s; cin >> s;
    vector<ll> bal = { 0 };
    for (auto i : s) {
        if (i == '(') {
            bal.push_back(bal.back() + 1);
        }
        else {
            bal.push_back(bal.back() - 1);
        }
    }
    segtree_mn mn(bal);
    segtree_hard hard(bal);

    while (q--) {
        ll l, r; cin >> l >> r;
        ll plus = bal[l - 1];

        ll ans = abs(bal[r] - plus);

        if (bal[r] - plus < 0) {
            plus += bal[r] - plus;
        }

        auto best = hard.get(l, r);
        ll worst = mn.get(l, r) - plus;
        if (worst >= 0) {
            cout << ans << '\n';
            continue;
        }
        cout << min(abs(worst) * 2, abs(worst - (bal[best.second] - plus)) * 2 * 2 + best.second - (l - 1))    + ans << '\n';
    }
         
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    solve();
}

